##############################################################################
### Template file         : dsrt.tmf
### File                  : Thermal_system_full.mk
### Compatibility         : DSMAKE 6.12
### Description           : Model specific makefile.
###
###
### Copyright 2019, dSPACE GmbH. All rights reserved.
###
##############################################################################

# ============================================================================
# NEVER CHANGE THIS LINE:
DSRT_MAKEFILE_TEMPLATE_VERSION = 11
# ============================================================================

# Version to control the handling of include paths in application process makefiles
%set INTERFACE_INCLUDE_MAKEFILE_VERSION := 2

# -----------------------------------------------------------------------------
# Make predefinitions.
# -----------------------------------------------------------------------------

.REJECT_RULES
.OPTIONS : MacroQuoted
.OPTIONS : TargetQuoted
.OPTIONS : TargetKeepCase

# -----------------------------------------------------------------------------
# Turn off warning for tokens declared as obsolete by MATLAB R2019a
# -----------------------------------------------------------------------------
# include a comment line in the .tmf files that includes
# NO_WARN_LEGACY_TOKENS
# This part shall be removed when the oldest supported MATLAB version is MATLAB R2019a

# -----------------------------------------------------------------------------
# Macros read by RTW.
# -----------------------------------------------------------------------------

# RTW specific environment specifications
# SECTION_DEFAULTS_RTW_BEGIN
MAKECMD                        = dsmake
HOST                           = PC
BUILD                          = no
BUILD_SUCCESS                  = DSRT: MAKE PROCESS SUCCEEDED
BUILD_ERROR                    = [sprintf('DSRT MAKE ERROR: Make process failed for model Thermal_system_full.')]
SYS_TARGET_FILE                = any
PROJ_MARKER_FILE               = no
VERBOSE_BUILD_OFF_TREATMENT    = PRINT_OUTPUT_ALWAYS
# SECTION_DEFAULTS_RTW_END


# -----------------------------------------------------------------------------
# Tokens expaned by RTW.
# -----------------------------------------------------------------------------

# RTW specific customization macros
# SECTION_CUSTOMIZATION_RTW_BEGIN
DS_PROTECTION                     = OFF
MW_MAKEFILE                       = Thermal_system_full.mk
MW_BUILDARGS                      =  MAT_FILE=0 COMBINE_OUTPUT_UPDATE_FCNS=0 INCLUDE_MDL_TERMINATE_FCN=1 MULTI_INSTANCE_CODE=0 OPTS="-DTID01EQ=1"
# MW_MATLAB_ROOT                  = "C:\Program Files\MATLAB\R2020b"
# MW_MATLAB_BIN                   = "C:\Program Files\MATLAB\R2020b\bin"
MATLAB_ROOT                       = C:\PROGRA~1\MATLAB\R2020b
MATLAB_BIN_ALT                    = C:\PROGRA~1\MATLAB\R2020b\bin
MW_RELEASE_VERSION                = R2020b
MW_RELEASE_VERSION               := $(MW_RELEASE_VERSION,S'\.'_',W_,LC,S'^r'')
# MW_COMPUTER                     = PCWIN64
MW_MODEL                          = Thermal_system_full
MW_MODEL_MODULES                  = Thermal_system_full_b8a6bb9a_1_ds.c Thermal_system_full_b8a6bb9a_1_ds_zc.c Thermal_system_full_b8a6bb9a_1_ds_tdxy_p.c Thermal_system_full_b8a6bb9a_1_ds_mdxy_p.c Thermal_system_full_b8a6bb9a_1_ds_dxy_p.c Thermal_system_full_b8a6bb9a_1_ds_y.c Thermal_system_full_b8a6bb9a_1_ds_obs_all.c Thermal_system_full_b8a6bb9a_1_ds_obs_act.c Thermal_system_full_b8a6bb9a_1_ds_obs_exp.c Thermal_system_full_b8a6bb9a_1_ds_mode.c Thermal_system_full_b8a6bb9a_1_ds_vmm.c Thermal_system_full_b8a6bb9a_1_ds_dxm_p.c Thermal_system_full_b8a6bb9a_1_ds_m_p.c Thermal_system_full_b8a6bb9a_1_ds_log.c Thermal_system_full_b8a6bb9a_1_ds_dxicr_p.c Thermal_system_full_b8a6bb9a_1_ds_obs_il.c Thermal_system_full_b8a6bb9a_1_ds_icr.c Thermal_system_full_b8a6bb9a_1_ds_dnf_v_x.c Thermal_system_full_b8a6bb9a_1_ds_dnf_p.c Thermal_system_full_b8a6bb9a_1_ds_lv.c Thermal_system_full_b8a6bb9a_1_ds_dxm.c Thermal_system_full_b8a6bb9a_1_ds_tdxf_p.c Thermal_system_full_b8a6bb9a_1_ds_a.c Thermal_system_full_b8a6bb9a_1_ds_dxy.c Thermal_system_full_b8a6bb9a_1_ds_tduf_p.c Thermal_system_full_b8a6bb9a_1_ds_duf_p.c Thermal_system_full_b8a6bb9a_1_ds_ic.c Thermal_system_full_b8a6bb9a_1_ds_slv.c Thermal_system_full_b8a6bb9a_1_ds_vmf.c Thermal_system_full_b8a6bb9a_1_ds_dxf_p.c Thermal_system_full_b8a6bb9a_1_ds_dnf.c Thermal_system_full_b8a6bb9a_1_ds_dxf.c Thermal_system_full_b8a6bb9a_1_ds_f.c Thermal_system_full_b8a6bb9a_1_ds_a_p.c Thermal_system_full_b8a6bb9a_1_ds_dxicr.c Thermal_system_full_b8a6bb9a_1_ds_b_p.c Thermal_system_full_b8a6bb9a_1_ds_iassert.c Thermal_system_full_b8a6bb9a_1_ds_m.c Thermal_system_full_b8a6bb9a_1_ds_duf.c Thermal_system_full_b8a6bb9a_1_ds_assert.c Thermal_system_full_b8a6bb9a_1.c Thermal_system_full_b8a6bb9a_1_gateway.c pm_printf.c rt_backsubrr_dbl.c rt_forwardsubrr_dbl.c rt_lu_real.c rt_matrixlib_dbl.c Thermal_system_full_data.c Thermal_system_full_dsrtmdlfcn.c Thermal_system_full_dsrtmf.c Thermal_system_full_dsrttf.c Thermal_system_full_dsrtvdf.c rtGetInf.c rtGetNaN.c rt_nonfinite.c
# MW_MODEL_MODULES_OBJ            = Thermal_system_full_b8a6bb9a_1_ds.obj Thermal_system_full_b8a6bb9a_1_ds_zc.obj Thermal_system_full_b8a6bb9a_1_ds_tdxy_p.obj Thermal_system_full_b8a6bb9a_1_ds_mdxy_p.obj Thermal_system_full_b8a6bb9a_1_ds_dxy_p.obj Thermal_system_full_b8a6bb9a_1_ds_y.obj Thermal_system_full_b8a6bb9a_1_ds_obs_all.obj Thermal_system_full_b8a6bb9a_1_ds_obs_act.obj Thermal_system_full_b8a6bb9a_1_ds_obs_exp.obj Thermal_system_full_b8a6bb9a_1_ds_mode.obj Thermal_system_full_b8a6bb9a_1_ds_vmm.obj Thermal_system_full_b8a6bb9a_1_ds_dxm_p.obj Thermal_system_full_b8a6bb9a_1_ds_m_p.obj Thermal_system_full_b8a6bb9a_1_ds_log.obj Thermal_system_full_b8a6bb9a_1_ds_dxicr_p.obj Thermal_system_full_b8a6bb9a_1_ds_obs_il.obj Thermal_system_full_b8a6bb9a_1_ds_icr.obj Thermal_system_full_b8a6bb9a_1_ds_dnf_v_x.obj Thermal_system_full_b8a6bb9a_1_ds_dnf_p.obj Thermal_system_full_b8a6bb9a_1_ds_lv.obj Thermal_system_full_b8a6bb9a_1_ds_dxm.obj Thermal_system_full_b8a6bb9a_1_ds_tdxf_p.obj Thermal_system_full_b8a6bb9a_1_ds_a.obj Thermal_system_full_b8a6bb9a_1_ds_dxy.obj Thermal_system_full_b8a6bb9a_1_ds_tduf_p.obj Thermal_system_full_b8a6bb9a_1_ds_duf_p.obj Thermal_system_full_b8a6bb9a_1_ds_ic.obj Thermal_system_full_b8a6bb9a_1_ds_slv.obj Thermal_system_full_b8a6bb9a_1_ds_vmf.obj Thermal_system_full_b8a6bb9a_1_ds_dxf_p.obj Thermal_system_full_b8a6bb9a_1_ds_dnf.obj Thermal_system_full_b8a6bb9a_1_ds_dxf.obj Thermal_system_full_b8a6bb9a_1_ds_f.obj Thermal_system_full_b8a6bb9a_1_ds_a_p.obj Thermal_system_full_b8a6bb9a_1_ds_dxicr.obj Thermal_system_full_b8a6bb9a_1_ds_b_p.obj Thermal_system_full_b8a6bb9a_1_ds_iassert.obj Thermal_system_full_b8a6bb9a_1_ds_m.obj Thermal_system_full_b8a6bb9a_1_ds_duf.obj Thermal_system_full_b8a6bb9a_1_ds_assert.obj Thermal_system_full_b8a6bb9a_1.obj Thermal_system_full_b8a6bb9a_1_gateway.obj pm_printf.obj rt_backsubrr_dbl.obj rt_forwardsubrr_dbl.obj rt_lu_real.obj rt_matrixlib_dbl.obj Thermal_system_full_data.obj Thermal_system_full_dsrtmdlfcn.obj Thermal_system_full_dsrtmf.obj Thermal_system_full_dsrttf.obj Thermal_system_full_dsrtvdf.obj rtGetInf.obj rtGetNaN.obj rt_nonfinite.obj 
MW_S_FUNCTIONS                    = 
# MW_S_FUNCTIONS_OBJ              = 
MW_S_FUNCTIONS_LIB                = 
# MW_SOLVER                       = 
# MW_SOLVER_OBJ                   = 
MW_NUMST                          = 2
MW_TID01EQ                        = 1
MW_NCSTATES                       = 641
# MW_EXT_MODE                     = 0
MW_MULTITASKING                   = 0
# Support for parallel computing
MASTER_ANCHOR_DIR                 = 
START_DIR                         = C:\Users\MATTIA~1\DOCUME~1\dSPACE\CONFIG~2\6.7\PR7BFB~1\APPLIC~1\COMPON~1\THERMA~1
MW_TARGET_LANG_EXT                = c
# MW_TGT_FCN_LIB                  = ISO_C
# MW_EXTMODE_STATIC_ALLOC         = 0
# MW_TMW_EXTMODE_TESTING          = 0
# MW_EXTMODE_STATIC_ALLOC_SIZE    = 1000000
# MW_EXTMODE_TRANSPORT            = 0
# Shared library for utility code
MW_SHARED_LIB                     = 
MW_SHARED_LIB_SRCS_WILD           = 
MW_SHARED_LIB_SRCS_DIR            = 
MW_SHARED_LIB_OBJS_DIR            = 

MW_RELATIVE_PATH_TO_ANCHOR        = ..

MW_MODELLIB                       = 
MW_MODELREF_LINK_LIBS             = 
MW_MODELREF_TARGET_TYPE           = NONE
MW_MODELREFS                      = 
MW_MODELREF_LINK_RSPFILE          = Thermal_system_full_ref.rsp
MW_MODELREF_INC_PATH              = 
# SECTION_CUSTOMIZATION_RTW_END

# -----------------------------------------------------------------------------
# Remove repeated items in MW_MODEL_MODULES to avoid linkage problems
# -----------------------------------------------------------------------------
%set TMP_UNIQUE_MODEL_MODULES =
%foreach ITEM in $(MW_MODEL_MODULES)
    # check if current ITEM is already contained in unique list.
    %if !member($(ITEM),$(TMP_UNIQUE_MODEL_MODULES))
        #avoid multiple source inclusions
        %set TMP_UNIQUE_MODEL_MODULES += $(ITEM)
    %endif
%endfor
# overwrite original list with unique one
%set MW_MODEL_MODULES := $(TMP_UNIQUE_MODEL_MODULES)
# remove temporal macro
%undef TMP_UNIQUE_MODEL_MODULES

# -----------------------------------------------------------------------------
# DSRT target specific configuration.
# -----------------------------------------------------------------------------

# In some dsmake versions (up to 6.26) the ,A modifier (abs. path) leaves behind a trailing \ character at the end.
# The S'\\$$'' removes such trailing \ character if it exists.
%set TMP_CHECK_START_DIR := $(INTERFACE_IN_INCLUDE_FILEPATH,D,>\$(MW_RELATIVE_PATH_TO_ANCHOR),A,S'\\$$'',$(WS_DEQUOTE))
%set TMP_CHECK_MATLAB_ROOT := "$(TMP_CHECK_START_DIR)\ml"
%if !(exists("$(TMP_CHECK_MATLAB_ROOT,A,$(WS_DEQUOTE))"))
   %set USE_LOCAL_SOURCES = no
%else
   %set USE_LOCAL_SOURCES = yes
%endif

%if '$(USE_LOCAL_SOURCES)' == 'yes'
%  set START_DIR := $(INTERFACE_IN_INCLUDE_FILEPATH,D,>\$(MW_RELATIVE_PATH_TO_ANCHOR),A,S'\\$$'',$(WS_DEQUOTE))
%  set MATLAB_ROOT := $(START_DIR)\ml
%endif

MODEL_MAKEFILE_BUILD_DIRPATH  = $(INTERFACE_IN_INCLUDE_FILEPATH,D)
MODEL_MAKEFILE_WORK_DIRPATH   = $(MODEL_MAKEFILE_BUILD_DIRPATH, >\$(MW_RELATIVE_PATH_TO_ANCHOR),A)

%ifdef CFG_VERSION_POSTFIX
% if $(CFG_VERSION_POSTFIX) != 1 
    QNX_VERSION_POSTFIX = _$(CFG_VERSION_POSTFIX)
% endif
%endif

DSRT_TARGET = $(SYS_TARGET_FILE,B)

WS_ESC = \\=\\\
WS_WILD = .=\.

# -----------------------------------------------------------------------------
# Model referencing settings.
# -----------------------------------------------------------------------------

# Evaluate Target Type for Model Referencing.

%if     '$(MW_MODELREF_TARGET_TYPE)' == 'NONE'
   # Root Model or no Model Referencing
%  set   _DSRT_IS_ROOT_MODEL = 1
%elseif '$(MW_MODELREF_TARGET_TYPE)' == 'RTW'
   # Referenced Model for Model Referencing
%  undef _DSRT_IS_ROOT_MODEL
%endif

%if !null(MW_MODELREFS)
   # This model includes other models/model libraries.
%  set   _DSRT_HAS_MODELREFS = 1
%else
   # No models referenced by this model.
%  undef _DSRT_HAS_MODELREFS
%endif

# -----------------------------------------------------------------------------
# Common search directories.
# -----------------------------------------------------------------------------

%set DSRT_COMMON_HDR_DIRPATHS := $(MODEL_MAKEFILE_BUILD_DIRPATH)
%set DSRT_COMMON_HDR_DIRPATHS += $(MODEL_MAKEFILE_WORK_DIRPATH,D)
%set DSRT_COMMON_HDR_DIRPATHS += "$(MATLAB_ROOT)\simulink\include"
%set DSRT_COMMON_HDR_DIRPATHS += "$(MATLAB_ROOT)\extern\include"
%set DSRT_COMMON_HDR_DIRPATHS += "$(MATLAB_ROOT)\rtw\c\src"
%set DSRT_COMMON_HDR_DIRPATHS += "$(MATLAB_ROOT)\rtw\c\src\ext_mode\common"
%set DSRT_COMMON_HDR_DIRPATHS += \
    "$(START_DIR)" \
    "$(START_DIR)\Thermal_system_full_dsrt" \
    "$(MATLAB_ROOT)\extern\include" \
    "$(MATLAB_ROOT)\simulink\include" \
    "$(MATLAB_ROOT)\rtw\c\src" \
    "$(MATLAB_ROOT)\rtw\c\src\ext_mode\common" \
    "$(MATLAB_ROOT)\toolbox\physmod\simscape\engine\sli\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\simscape\engine\core\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\simscape\compiler\core\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\network_engine\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\common\math\core\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\common\lang\core\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\common\external\library\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\common\foundation\core\c\win64"

%if !null(MW_MODELREF_INC_PATH) 
%set DSRT_COMMON_HDR_DIRPATHS    += $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(MW_MODELREF_INC_PATH))
%elseif dir($(MODEL_MAKEFILE_BUILD_DIRPATH,>\referenced_model_includes))
# in MATLAB R2019a the MW_MODELREF_INC_PATH macro is always empty
# Temporal Fix/Hack for MATLAB 2019a It is assumed that the folder with all referenced model header is called \referenced_model_includes
%set DSRT_COMMON_HDR_DIRPATHS    += $(MODEL_MAKEFILE_BUILD_DIRPATH,>\referenced_model_includes)
%endif

%if !null(MW_SHARED_LIB_SRCS_DIR) 
%if !(%exists("$(MW_SHARED_LIB_SRCS_DIR,$(WS_DEQUOTE))"))
%set DSRT_COMMON_HDR_DIRPATHS    += $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(MW_SHARED_LIB_SRCS_DIR))
%else
%set DSRT_COMMON_HDR_DIRPATHS    += "$(MW_SHARED_LIB_SRCS_DIR,$(WS_DEQUOTE))"
%endif
%endif

%set DSRT_COMMON_SRC_DIRPATHS := $(DSRT_COMMON_HDR_DIRPATHS)
%set DSRT_COMMON_SRC_DIRPATHS += \
    "$(MATLAB_ROOT)\toolbox\physmod\simscape\engine\sli\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\simscape\engine\core\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\simscape\compiler\core\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\network_engine\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\common\math\core\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\common\lang\core\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\common\external\library\c\win64" \
    "$(MATLAB_ROOT)\toolbox\physmod\common\foundation\core\c\win64" \
    "$(MATLAB_ROOT)\rtw\c\src" \
    "$(MATLAB_ROOT)\simulink\src"

%if '$(USE_LOCAL_SOURCES)' == 'yes'
%  set DSRT_COMMON_HDR_DIRPATHS += "$(START_DIR)\otherFiles"
%  set DSRT_COMMON_HDR_DIRPATHS += "$(START_DIR)\PI\misc"
%  set DSRT_COMMON_SRC_DIRPATHS += "$(START_DIR)\otherFiles"
%  set DSRT_COMMON_SRC_DIRPATHS += "$(START_DIR)\PI\misc"
%  set TMP_START_DIR = $(START_DIR,$(WS_ESC))
%  set TMP_START_DIR = $(TMP_START_DIR,$(WS_WILD))
%  set DSRT_COMMON_HDR_DIRPATHS = $(DSRT_COMMON_HDR_DIRPATHS,M^$(TMP_START_DIR))
%  set DSRT_COMMON_SRC_DIRPATHS = $(DSRT_COMMON_SRC_DIRPATHS,M^$(TMP_START_DIR))
%endif

# -----------------------------------------------------------------------------
# Common compiler defines.
# -----------------------------------------------------------------------------

TMP_INTERFACE_CC_ADD_DEFINES    = USE_RTMODEL
TMP_INTERFACE_CC_ADD_DEFINES   += MODEL=$(MW_MODEL)
TMP_INTERFACE_CC_ADD_DEFINES   += MT=$(MW_MULTITASKING)
TMP_INTERFACE_CC_ADD_DEFINES   += RT
TMP_INTERFACE_CC_ADD_DEFINES   += NUMST=$(MW_NUMST)
TMP_INTERFACE_CC_ADD_DEFINES   += NCSTATES=$(MW_NCSTATES)
TMP_INTERFACE_CC_ADD_DEFINES   += NO_PRINTF
TMP_INTERFACE_CC_ADD_DEFINES   += TID01EQ=$(MW_TID01EQ)

# -----------------------------------------------------------------------------
# Shared library for utility code
# -----------------------------------------------------------------------------
%if !null(_DSRT_IS_ROOT_MODEL)
%if !null(MW_SHARED_LIB_SRCS_DIR)
%if !null(MW_SHARED_LIB)
%set MW_SHARED_LIB_BASENAME := $(MW_SHARED_LIB,B)

# MMPAP: Rename shared library "basename" if already present in INTERFACE_IN_LIB_TARGETS
%foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(MW_SHARED_LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set MW_SHARED_LIB_BASENAME = $(MW_SHARED_LIB_BASENAME)_1
%    else
%        break
%    endif
%endfor

%set MW_SHARED_LIB_FILEPATH =$(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(MW_SHARED_LIB))
# add renamed basename to the INTERFACE_LIB_TARGET list.
%set INTERFACE_LIB_TARGET +=$(MW_SHARED_LIB_BASENAME)
# save shared library in the model folder. Do not use renamed MW_SHARED_LIB_BASENAME, use MW_SHARED_LIB instead.
# Generate macros to build MW_SHARED_LIB_BASENAME library.
%set INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_FILELOCATION     =$(MW_SHARED_LIB_FILEPATH)
%set INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_SRC_FILES     =$(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(MW_SHARED_LIB_SRCS_WILD),A,*F)
%if !(%exists("$(MW_SHARED_LIB_SRCS_DIR,$(WS_DEQUOTE))"))
%   set INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_SRC_DIRPATHS  =$(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(MW_SHARED_LIB_SRCS_DIR),A)
%else
%   set INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_SRC_DIRPATHS  ="$(MW_SHARED_LIB_SRCS_DIR,$(WS_DEQUOTE))"
%endif
%set INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_HDR_DIRPATHS  =$(DSRT_COMMON_HDR_DIRPATHS)
%set INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_ADD_DEFINES   =$(TMP_INTERFACE_CC_ADD_DEFINES)
%endif

%endif
%ifdef DEBUG_ON
% echo DEBUG: INTERFACE_LIB_TARGET $(INTERFACE_LIB_TARGET)
% echo DEBUG: INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_FILELOCATION $(INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_FILELOCATION)
% echo DEBUG: INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_SRC_FILES $(INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_SRC_FILES)
% echo DEBUG: INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_SRC_DIRPATHS $(INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_SRC_DIRPATHS)
% echo DEBUG: INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_HDR_DIRPATHS $(INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_HDR_DIRPATHS)
% echo DEBUG: INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_ADD_DEFINES $(INTERFACE_LIB_$(MW_SHARED_LIB_BASENAME)_CC_ADD_DEFINES)
%endif
%endif # _DSRT_IS_ROOT_MODEL

# -----------------------------------------------------------------------------
# Sources and objects for RTW Custom Run-Time libraries
# -----------------------------------------------------------------------------

%if !null(_DSRT_IS_ROOT_MODEL)

# List of RTW Custom Run-Time Libraries and related sources.
# * (to be built)    ssc_sli$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
# * (to be built)    ssc_core$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
# * (to be built)    ne$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
# * (to be built)    mc$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
# * (to be built)    ex$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
# * (to be built)    pm$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)


# RTW Custom Run-Time Libraries from rtwmakecfg.m (to be built).
# * Library name:    ssc_sli$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT).
%set _RTWCUST_LIB                             = ssc_sli$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
%ifdef DEBUG_ON
% echo DEBUG: Library $(_RTWCUST_LIB) is to be built or updated.
%endif

%set LIB_BASENAME = ssc_sli

% foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set LIB_BASENAME = $(LIB_BASENAME)_1
%    else
%        break
%    endif
% endfor

%set INTERFACE_LIB_TARGET                 += $(LIB_BASENAME)
%set INTERFACE_LIB_$(LIB_BASENAME)_FILELOCATION = $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(_RTWCUST_LIB))
%undef _RTWCUST_LIB

#   Search paths:
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS   := $(DSRT_COMMON_SRC_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_HDR_DIRPATHS   := $(DSRT_COMMON_HDR_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_ADD_DEFINES    := $(TMP_INTERFACE_CC_ADD_DEFINES)
#   Sources for :    $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# For library sources the file type (.c/.cpp) is not known.
# The type will be determined by testing the existence of the file with the respective
# extensions, where current target language (MW_TARGET_LANG_EXT) is the default.
%if $(MW_TARGET_LANG_EXT) == c
    %set _NOT_MW_TARGET_LANG_EXT = cpp
%else 
    %set _NOT_MW_TARGET_LANG_EXT = c
%endif 
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := 
%set TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := \
   ssc_sli_0763c151 \
   ssc_sli_0bd269e6 \
   ssc_sli_0d6d0780 \
   ssc_sli_136b443c \
   ssc_sli_136f97a1 \
   ssc_sli_140b3534 \
   ssc_sli_15d5f6ce \
   ssc_sli_1c690f90 \
   ssc_sli_1db813e8 \
   ssc_sli_2bbd58a4 \
   ssc_sli_2f6ea1cd \
   ssc_sli_360cfd63 \
   ssc_sli_42b14021 \
   ssc_sli_43618287 \
   ssc_sli_466b08dd \
   ssc_sli_496799bd \
   ssc_sli_4e028390 \
   ssc_sli_51dbd3b5 \
   ssc_sli_550a4805 \
   ssc_sli_5a0cb974 \
   ssc_sli_5d63aeeb \
   ssc_sli_62d81790 \
   ssc_sli_77063d8b \
   ssc_sli_7a618260 \
   ssc_sli_7f65db03 \
   ssc_sli_880e593a \
   ssc_sli_89d0f30a \
   ssc_sli_8a64c4e2 \
   ssc_sli_93019ea6 \
   ssc_sli_9abcdb7f \
   ssc_sli_9b67747c \
   ssc_sli_9c030181 \
   ssc_sli_c7dda239 \
   ssc_sli_d064c978 \
   ssc_sli_d80c44d2 \
   ssc_sli_dcd66f69 \
   ssc_sli_e66fe6d5 \
   ssc_sli_e7b327bb \
   ssc_sli_eb0a5702 \
   ssc_sli_edbee55c \
   ssc_sli_f6bd9cc8 \
   ssc_sli_f9b5dbc5 \
   ssc_sli_fa0ce53e \
   ssc_sli_fbdf29da

# Loop over all sources in list.
# Test existence of source file with different extensions (.c/.cpp) to determine actual file type.  
%foreach ITEM_TMP in $(TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES)
    # Default is source file of type MW_TARGET_LANG_EXT.
    %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(MW_TARGET_LANG_EXT)
    # Loop over all source directories assigned to this source list.
    %foreach ITEM_FILE in $(INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS,>\$(ITEM_TMP))
        # Look for source files in all dir paths. If a matching file is found, break search.
        # For two files with the same file name, MW_TARGET_LANG_EXT wins.
        %if %file($(_TMP_FILE_WITH_EXTENSION))
            %break
        %elseif %file($(ITEM_FILE).$(_NOT_MW_TARGET_LANG_EXT))
            %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(_NOT_MW_TARGET_LANG_EXT)
            %break
        %endif
    %endfor
    # Add result to final list.
    %set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES += $(_TMP_FILE_WITH_EXTENSION)
%endfor

%undef TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES
%undef _NOT_MW_TARGET_LANG_EXT

#   End :            $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# * Library name:    ssc_core$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT).
%set _RTWCUST_LIB                             = ssc_core$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
%ifdef DEBUG_ON
% echo DEBUG: Library $(_RTWCUST_LIB) is to be built or updated.
%endif

%set LIB_BASENAME = ssc_core

% foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set LIB_BASENAME = $(LIB_BASENAME)_1
%    else
%        break
%    endif
% endfor

%set INTERFACE_LIB_TARGET                 += $(LIB_BASENAME)
%set INTERFACE_LIB_$(LIB_BASENAME)_FILELOCATION = $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(_RTWCUST_LIB))
%undef _RTWCUST_LIB

#   Search paths:
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS   := $(DSRT_COMMON_SRC_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_HDR_DIRPATHS   := $(DSRT_COMMON_HDR_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_ADD_DEFINES    := $(TMP_INTERFACE_CC_ADD_DEFINES)
#   Sources for :    $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# For library sources the file type (.c/.cpp) is not known.
# The type will be determined by testing the existence of the file with the respective
# extensions, where current target language (MW_TARGET_LANG_EXT) is the default.
%if $(MW_TARGET_LANG_EXT) == c
    %set _NOT_MW_TARGET_LANG_EXT = cpp
%else 
    %set _NOT_MW_TARGET_LANG_EXT = c
%endif 
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := 
%set TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := \
   ssc_core_01dcc633 \
   ssc_core_04da2c69 \
   ssc_core_05058dd9 \
   ssc_core_06ba68a6 \
   ssc_core_09b5fa6e \
   ssc_core_0bd666aa \
   ssc_core_0f019bd9 \
   ssc_core_0f0420a6 \
   ssc_core_18bf4d77 \
   ssc_core_1b0cafd5 \
   ssc_core_1c6b0332 \
   ssc_core_1fd25120 \
   ssc_core_24b4cdee \
   ssc_core_2568b075 \
   ssc_core_280c0222 \
   ssc_core_2cd54448 \
   ssc_core_3169e4b7 \
   ssc_core_360a4baf \
   ssc_core_37d4ea84 \
   ssc_core_40dfdbdc \
   ssc_core_41017299 \
   ssc_core_4666b45b \
   ssc_core_48b08af1 \
   ssc_core_48b1386a \
   ssc_core_4965213d \
   ssc_core_4ad9135b \
   ssc_core_4db6bd68 \
   ssc_core_4db86fcc \
   ssc_core_4e03e39d \
   ssc_core_4e04eecd \
   ssc_core_54d55ae9 \
   ssc_core_5505224d \
   ssc_core_56b1a2bf \
   ssc_core_576cd129 \
   ssc_core_59b034b8 \
   ssc_core_5a046b27 \
   ssc_core_5d6ba758 \
   ssc_core_60b0e4dc \
   ssc_core_67d1f118 \
   ssc_core_68da074b \
   ssc_core_6b663a17 \
   ssc_core_6b6b89d2 \
   ssc_core_6dd833f3 \
   ssc_core_73d9c2b7 \
   ssc_core_76d825be \
   ssc_core_79dd08ab \
   ssc_core_7a613edb \
   ssc_core_83db8762 \
   ssc_core_856738f2 \
   ssc_core_8569edc5 \
   ssc_core_89d7fa79 \
   ssc_core_8a6471dc \
   ssc_core_8d0064b8 \
   ssc_core_96061071 \
   ssc_core_97d767fe \
   ssc_core_990fe1a4 \
   ssc_core_9b607b15 \
   ssc_core_9c016445 \
   ssc_core_9c01d168 \
   ssc_core_9dd110ad \
   ssc_core_9fb0e229 \
   ssc_core_9fb25b4f \
   ssc_core_9fb2e56c \
   ssc_core_a1d393be \
   ssc_core_a4d4c45e \
   ssc_core_a4da1d0a \
   ssc_core_a6b78ccc \
   ssc_core_a76299bc \
   ssc_core_a867d880 \
   ssc_core_a9bf1ff2 \
   ssc_core_abd05c18 \
   ssc_core_abd5e7b4 \
   ssc_core_acb64294 \
   ssc_core_acb6462e \
   ssc_core_b1038cbb \
   ssc_core_b10e34f4 \
   ssc_core_b2b3b239 \
   ssc_core_b402b40d \
   ssc_core_b7b88213 \
   ssc_core_b96ebc21 \
   ssc_core_bc648043 \
   ssc_core_bfdb08db \
   ssc_core_c3003040 \
   ssc_core_c5b050d7 \
   ssc_core_c5b63cb2 \
   ssc_core_c607b660 \
   ssc_core_c8d33536 \
   ssc_core_c8d83e88 \
   ssc_core_cab615c8 \
   ssc_core_cabdc251 \
   ssc_core_cc067f58 \
   ssc_core_ce6a84bb \
   ssc_core_d06d763c \
   ssc_core_d3d34d7c \
   ssc_core_d70a6a09 \
   ssc_core_d807fa59 \
   ssc_core_dcda6edd \
   ssc_core_deb7fd8d \
   ssc_core_e0d0866d \
   ssc_core_e2b61d72 \
   ssc_core_e400c1c2 \
   ssc_core_ead8f455 \
   ssc_core_ee000fbe \
   ssc_core_ee01086d \
   ssc_core_ee0f0141 \
   ssc_core_f9b6dbed \
   ssc_core_fa09e9e6 \
   ssc_core_fbd34e62 \
   ssc_core_ff06d9a4

# Loop over all sources in list.
# Test existence of source file with different extensions (.c/.cpp) to determine actual file type.  
%foreach ITEM_TMP in $(TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES)
    # Default is source file of type MW_TARGET_LANG_EXT.
    %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(MW_TARGET_LANG_EXT)
    # Loop over all source directories assigned to this source list.
    %foreach ITEM_FILE in $(INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS,>\$(ITEM_TMP))
        # Look for source files in all dir paths. If a matching file is found, break search.
        # For two files with the same file name, MW_TARGET_LANG_EXT wins.
        %if %file($(_TMP_FILE_WITH_EXTENSION))
            %break
        %elseif %file($(ITEM_FILE).$(_NOT_MW_TARGET_LANG_EXT))
            %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(_NOT_MW_TARGET_LANG_EXT)
            %break
        %endif
    %endfor
    # Add result to final list.
    %set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES += $(_TMP_FILE_WITH_EXTENSION)
%endfor

%undef TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES
%undef _NOT_MW_TARGET_LANG_EXT

#   End :            $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# * Library name:    ne$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT).
%set _RTWCUST_LIB                             = ne$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
%ifdef DEBUG_ON
% echo DEBUG: Library $(_RTWCUST_LIB) is to be built or updated.
%endif

%set LIB_BASENAME = ne

% foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set LIB_BASENAME = $(LIB_BASENAME)_1
%    else
%        break
%    endif
% endfor

%set INTERFACE_LIB_TARGET                 += $(LIB_BASENAME)
%set INTERFACE_LIB_$(LIB_BASENAME)_FILELOCATION = $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(_RTWCUST_LIB))
%undef _RTWCUST_LIB

#   Search paths:
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS   := $(DSRT_COMMON_SRC_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_HDR_DIRPATHS   := $(DSRT_COMMON_HDR_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_ADD_DEFINES    := $(TMP_INTERFACE_CC_ADD_DEFINES)
#   Sources for :    $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# For library sources the file type (.c/.cpp) is not known.
# The type will be determined by testing the existence of the file with the respective
# extensions, where current target language (MW_TARGET_LANG_EXT) is the default.
%if $(MW_TARGET_LANG_EXT) == c
    %set _NOT_MW_TARGET_LANG_EXT = cpp
%else 
    %set _NOT_MW_TARGET_LANG_EXT = c
%endif 
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := 
%set TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := \
   ne_59b4e14a

# Loop over all sources in list.
# Test existence of source file with different extensions (.c/.cpp) to determine actual file type.  
%foreach ITEM_TMP in $(TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES)
    # Default is source file of type MW_TARGET_LANG_EXT.
    %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(MW_TARGET_LANG_EXT)
    # Loop over all source directories assigned to this source list.
    %foreach ITEM_FILE in $(INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS,>\$(ITEM_TMP))
        # Look for source files in all dir paths. If a matching file is found, break search.
        # For two files with the same file name, MW_TARGET_LANG_EXT wins.
        %if %file($(_TMP_FILE_WITH_EXTENSION))
            %break
        %elseif %file($(ITEM_FILE).$(_NOT_MW_TARGET_LANG_EXT))
            %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(_NOT_MW_TARGET_LANG_EXT)
            %break
        %endif
    %endfor
    # Add result to final list.
    %set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES += $(_TMP_FILE_WITH_EXTENSION)
%endfor

%undef TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES
%undef _NOT_MW_TARGET_LANG_EXT

#   End :            $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# * Library name:    mc$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT).
%set _RTWCUST_LIB                             = mc$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
%ifdef DEBUG_ON
% echo DEBUG: Library $(_RTWCUST_LIB) is to be built or updated.
%endif

%set LIB_BASENAME = mc

% foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set LIB_BASENAME = $(LIB_BASENAME)_1
%    else
%        break
%    endif
% endfor

%set INTERFACE_LIB_TARGET                 += $(LIB_BASENAME)
%set INTERFACE_LIB_$(LIB_BASENAME)_FILELOCATION = $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(_RTWCUST_LIB))
%undef _RTWCUST_LIB

#   Search paths:
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS   := $(DSRT_COMMON_SRC_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_HDR_DIRPATHS   := $(DSRT_COMMON_HDR_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_ADD_DEFINES    := $(TMP_INTERFACE_CC_ADD_DEFINES)
#   Sources for :    $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# For library sources the file type (.c/.cpp) is not known.
# The type will be determined by testing the existence of the file with the respective
# extensions, where current target language (MW_TARGET_LANG_EXT) is the default.
%if $(MW_TARGET_LANG_EXT) == c
    %set _NOT_MW_TARGET_LANG_EXT = cpp
%else 
    %set _NOT_MW_TARGET_LANG_EXT = c
%endif 
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := 
%set TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := \
   mc_026e4f4b \
   mc_03b98f6f \
   mc_0764157d \
   mc_0bd30dee \
   mc_0d6fd085 \
   mc_0ed73c49 \
   mc_0edc34e3 \
   mc_10d4ab75 \
   mc_11086079 \
   mc_110e6c6c \
   mc_140e3c4c \
   mc_15d12d95 \
   mc_15d828ca \
   mc_220ba961 \
   mc_2565d6e0 \
   mc_2a642f54 \
   mc_2a6a9b24 \
   mc_2bbf87e3 \
   mc_2cdc96b4 \
   mc_32d501e3 \
   mc_32dc008a \
   mc_3b6a945d \
   mc_3e66abdf \
   mc_4105189f \
   mc_47b8cebe \
   mc_47b91db1 \
   mc_4b0301c6 \
   mc_4c6117e3 \
   mc_51d4094e \
   mc_52623861 \
   mc_52688a58 \
   mc_53b1fc84 \
   mc_53b6fcf3 \
   mc_550847c3 \
   mc_5766048f \
   mc_59b6e413 \
   mc_5d65cd86 \
   mc_5edd42ef \
   mc_630208f8 \
   mc_630dda0e \
   mc_67da200d \
   mc_67da4f41 \
   mc_6b6d311a \
   mc_6e61d16c \
   mc_6fb1c336 \
   mc_7809a65c \
   mc_7a613aec \
   mc_7bbf41f0 \
   mc_7cd58f0b \
   mc_7cdbe436 \
   mc_7d0547c8 \
   mc_7d099de7 \
   mc_7eb21b39 \
   mc_81b0ada5 \
   mc_81b5717e \
   mc_870ec75e \
   mc_89d597cf \
   mc_90b6aa0a \
   mc_95b62b73 \
   mc_9ab7d9b0 \
   mc_9b6376d1 \
   mc_9b6c1529 \
   mc_a2647600 \
   mc_a26bab1a \
   mc_a3b90582 \
   mc_a7684938 \
   mc_a865d1dd \
   mc_acb3fad7 \
   mc_af0bc203 \
   mc_af0cc4c9 \
   mc_b0de9cbc \
   mc_b362c5eb \
   mc_b7b03d44 \
   mc_b96a0bad \
   mc_bb0520ee \
   mc_bdbb9b78 \
   mc_c2dbf4b2 \
   mc_c8d25d23 \
   mc_cab8a1f9 \
   mc_ce6656ce \
   mc_d20085b7 \
   mc_d9d38185 \
   mc_dbbb14d2 \
   mc_dcdddfae \
   mc_debb448f \
   mc_e7bc2f1a \
   mc_e969ae87 \
   mc_edbf543c \
   mc_ee000fbe \
   mc_efdea3a7 \
   mc_f00d2f9b \
   mc_f3be157c \
   mc_fbd54145 \
   mc_fcb15a9b \
   mc_fd619d14 \
   mc_fd6341bb

# Loop over all sources in list.
# Test existence of source file with different extensions (.c/.cpp) to determine actual file type.  
%foreach ITEM_TMP in $(TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES)
    # Default is source file of type MW_TARGET_LANG_EXT.
    %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(MW_TARGET_LANG_EXT)
    # Loop over all source directories assigned to this source list.
    %foreach ITEM_FILE in $(INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS,>\$(ITEM_TMP))
        # Look for source files in all dir paths. If a matching file is found, break search.
        # For two files with the same file name, MW_TARGET_LANG_EXT wins.
        %if %file($(_TMP_FILE_WITH_EXTENSION))
            %break
        %elseif %file($(ITEM_FILE).$(_NOT_MW_TARGET_LANG_EXT))
            %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(_NOT_MW_TARGET_LANG_EXT)
            %break
        %endif
    %endfor
    # Add result to final list.
    %set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES += $(_TMP_FILE_WITH_EXTENSION)
%endfor

%undef TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES
%undef _NOT_MW_TARGET_LANG_EXT

#   End :            $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# * Library name:    ex$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT).
%set _RTWCUST_LIB                             = ex$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
%ifdef DEBUG_ON
% echo DEBUG: Library $(_RTWCUST_LIB) is to be built or updated.
%endif

%set LIB_BASENAME = ex

% foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set LIB_BASENAME = $(LIB_BASENAME)_1
%    else
%        break
%    endif
% endfor

%set INTERFACE_LIB_TARGET                 += $(LIB_BASENAME)
%set INTERFACE_LIB_$(LIB_BASENAME)_FILELOCATION = $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(_RTWCUST_LIB))
%undef _RTWCUST_LIB

#   Search paths:
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS   := $(DSRT_COMMON_SRC_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_HDR_DIRPATHS   := $(DSRT_COMMON_HDR_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_ADD_DEFINES    := $(TMP_INTERFACE_CC_ADD_DEFINES)
#   Sources for :    $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# For library sources the file type (.c/.cpp) is not known.
# The type will be determined by testing the existence of the file with the respective
# extensions, where current target language (MW_TARGET_LANG_EXT) is the default.
%if $(MW_TARGET_LANG_EXT) == c
    %set _NOT_MW_TARGET_LANG_EXT = cpp
%else 
    %set _NOT_MW_TARGET_LANG_EXT = c
%endif 
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := 
%set TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := \
   ex_04d5441d \
   ex_136645f8 \
   ex_17bc61ac \
   ex_18b4440a \
   ex_2ebcd5b2 \
   ex_316a81de \
   ex_36012fa7 \
   ex_40d5be33 \
   ex_47b11894 \
   ex_57660158 \
   ex_690b7cd0 \
   ex_79d100f1 \
   ex_8a6fc761 \
   ex_98d223a6 \
   ex_aed5de1e \
   ex_b2b40ad5 \
   ex_bb0efd4b \
   ex_c9069dae \
   ex_d9d686a8 \
   ex_debffef2 \
   ex_e40d74b8 \
   ex_eb0d559b \
   ex_f6bb4c2d \
   ex_f866102d

# Loop over all sources in list.
# Test existence of source file with different extensions (.c/.cpp) to determine actual file type.  
%foreach ITEM_TMP in $(TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES)
    # Default is source file of type MW_TARGET_LANG_EXT.
    %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(MW_TARGET_LANG_EXT)
    # Loop over all source directories assigned to this source list.
    %foreach ITEM_FILE in $(INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS,>\$(ITEM_TMP))
        # Look for source files in all dir paths. If a matching file is found, break search.
        # For two files with the same file name, MW_TARGET_LANG_EXT wins.
        %if %file($(_TMP_FILE_WITH_EXTENSION))
            %break
        %elseif %file($(ITEM_FILE).$(_NOT_MW_TARGET_LANG_EXT))
            %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(_NOT_MW_TARGET_LANG_EXT)
            %break
        %endif
    %endfor
    # Add result to final list.
    %set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES += $(_TMP_FILE_WITH_EXTENSION)
%endfor

%undef TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES
%undef _NOT_MW_TARGET_LANG_EXT

#   End :            $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# * Library name:    pm$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT).
%set _RTWCUST_LIB                             = pm$(DSRT_RTWCUST_LIB_PLATFORM_EXT).$(CFG_LIB_FILE_EXT)
%ifdef DEBUG_ON
% echo DEBUG: Library $(_RTWCUST_LIB) is to be built or updated.
%endif

%set LIB_BASENAME = pm

% foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set LIB_BASENAME = $(LIB_BASENAME)_1
%    else
%        break
%    endif
% endfor

%set INTERFACE_LIB_TARGET                 += $(LIB_BASENAME)
%set INTERFACE_LIB_$(LIB_BASENAME)_FILELOCATION = $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(_RTWCUST_LIB))
%undef _RTWCUST_LIB

#   Search paths:
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS   := $(DSRT_COMMON_SRC_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_HDR_DIRPATHS   := $(DSRT_COMMON_HDR_DIRPATHS)
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_ADD_DEFINES    := $(TMP_INTERFACE_CC_ADD_DEFINES)
#   Sources for :    $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).
# For library sources the file type (.c/.cpp) is not known.
# The type will be determined by testing the existence of the file with the respective
# extensions, where current target language (MW_TARGET_LANG_EXT) is the default.
%if $(MW_TARGET_LANG_EXT) == c
    %set _NOT_MW_TARGET_LANG_EXT = cpp
%else 
    %set _NOT_MW_TARGET_LANG_EXT = c
%endif 
%set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := 
%set TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := \
   pm_09bc42e2 \
   pm_14098e54 \
   pm_26dc3230 \
   pm_4fd5f5b9 \
   pm_fed8c2c9

# Loop over all sources in list.
# Test existence of source file with different extensions (.c/.cpp) to determine actual file type.  
%foreach ITEM_TMP in $(TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES)
    # Default is source file of type MW_TARGET_LANG_EXT.
    %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(MW_TARGET_LANG_EXT)
    # Loop over all source directories assigned to this source list.
    %foreach ITEM_FILE in $(INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS,>\$(ITEM_TMP))
        # Look for source files in all dir paths. If a matching file is found, break search.
        # For two files with the same file name, MW_TARGET_LANG_EXT wins.
        %if %file($(_TMP_FILE_WITH_EXTENSION))
            %break
        %elseif %file($(ITEM_FILE).$(_NOT_MW_TARGET_LANG_EXT))
            %set _TMP_FILE_WITH_EXTENSION := $(ITEM_TMP).$(_NOT_MW_TARGET_LANG_EXT)
            %break
        %endif
    %endfor
    # Add result to final list.
    %set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES += $(_TMP_FILE_WITH_EXTENSION)
%endfor

%undef TMP_INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES
%undef _NOT_MW_TARGET_LANG_EXT

#   End :            $(LIB_BASENAME)_ds$(BOARD_TYPE).$(CFG_LIB_FILE_EXT).


# RTW Custom Run-Time Libraries from rtwmakecfg.m (pre-compiled, locally build if unavailable).


%endif # _DSRT_IS_ROOT_MODEL

# -----------------------------------------------------------------------------
# Interface macros for root/main model.
# -----------------------------------------------------------------------------
%if !null(_DSRT_IS_ROOT_MODEL)

%set LIB_BASENAME = Thermal_system_full

% foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set LIB_BASENAME = $(LIB_BASENAME)_1
%    else
%        break
%    endif
% endfor

% set INTERFACE_LIB_TARGET += $(LIB_BASENAME)
% set INTERFACE_LIB_MAIN_TARGET = $(LIB_BASENAME)
% set INTERFACE_IMPLEMENTATION_TYPE = SimulinkImplementation
% set INTERFACE_LIB_$(LIB_BASENAME)_FILELOCATION = $(MODEL_MAKEFILE_BUILD_DIRPATH,>\$(LIB_BASENAME).$(CFG_LIB_FILE_EXT))

# Search path for header files and include path.
INTERFACE_LIB_$(LIB_BASENAME)_CC_HDR_DIRPATHS := $(DSRT_COMMON_HDR_DIRPATHS)
INTERFACE_CC_HDR_DIRPATHS := $(DSRT_COMMON_HDR_DIRPATHS)

# Search path for source files.
INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS := $(DSRT_COMMON_SRC_DIRPATHS)

# Interface macros for integration with ConfigurationDesk.
INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES := Thermal_system_full.$(MW_TARGET_LANG_EXT) 
INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES += $(MW_MODEL_MODULES)
INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES += $(MW_S_FUNCTIONS)

INTERFACE_LIB_$(LIB_BASENAME)_CC_ADD_DEFINES := $(TMP_INTERFACE_CC_ADD_DEFINES)

INTERFACE_OBJ_FILEPATHS +=


%endif # _DSRT_IS_ROOT_MODEL

# -----------------------------------------------------------------------------
# Interface macros for library targets of referenced models.
# -----------------------------------------------------------------------------

%if null(_DSRT_IS_ROOT_MODEL)

% set LIB_BASENAME = $(MW_MODELLIB,B)

% foreach ITEM in $(INTERFACE_IN_LIB_TARGETS)
%    if member($(LIB_BASENAME), $(INTERFACE_IN_LIB_TARGETS))
%        set LIB_BASENAME = $(LIB_BASENAME)_1
%    else
%        break
%    endif
% endfor

# Library targets of referenced models.
% set INTERFACE_LIB_TARGET                 += $(LIB_BASENAME)

% set TMP_REF_MODEL_BUILD_DIR := $(INTERFACE_IN_INCLUDE_FILEPATH,D)

% set INTERFACE_LIB_$(LIB_BASENAME)_FILELOCATION     := $(TMP_REF_MODEL_BUILD_DIR,>\$(LIB_BASENAME)$(MW_MODELLIB,E))
% set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES     := $(MW_MODEL_MODULES)
% set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_FILES     += $(MW_S_FUNCTIONS)
% set INTERFACE_LIB_$(LIB_BASENAME)_CC_SRC_DIRPATHS  := $(DSRT_COMMON_SRC_DIRPATHS)
% set INTERFACE_LIB_$(LIB_BASENAME)_CC_HDR_DIRPATHS  := $(DSRT_COMMON_HDR_DIRPATHS)
% set INTERFACE_LIB_$(LIB_BASENAME)_CC_ADD_DEFINES   := $(TMP_INTERFACE_CC_ADD_DEFINES)

%endif # !_DSRT_IS_ROOT_MODEL

local_start_$(MW_MODEL):
%if '$(DS_PROTECTION)' == 'ON'
    %echo $(BUILD_SUCCESS)
%endif
# [EOF]
